/*------------------------------------------------------------------------------*
 * File Name: graph.h															*
 * Creation: 9/5/2001														    *
 * Purpose: Origin C header	for GraphLayer class and other related functions	*
 * Copyright (c) OriginLab Corp.2001											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	RVD 2/16/2005 QA70-7289 v8.0185 WKS_THEME_SUPPORT							*
 *	ML 2/21/2005 DELETING_INSERTING_ROWS_IN_TABLE_WITH_LINKS					*
 *	ML 2/22/2005 GETTING_GRIDTABLE_NID											*
 *	RVD 2/28/2005 QA70-7446 v8.0199 GRID_NAMED_STYLES							*
 *	ML 11/18/2005 QA70-8332 SETTING_MF_TO_GRAPHOBJECT_OC						*
 *	RVD 4/7/2006 QA70-8609 v8.0387 TABLE_GRID_BORDERS							*
 *	ML 8/7/2006 GET_SET_SHOW_LABELS_BY_ARRAY_OF_TYPES							*
 *	ML 1/22/2007 QA70-9189 MAKING_A_FLAT_SHEET_WITH_LINKS_ONLY_AND_IN_DATA_AS_WELL_AS_LABELS_AREA_OUT_OF_A_WHOLE_SOURCE_TABLE
 *  SY 2007-03-06 QA70-9440 v8.0577 OC_METHOD_REDUCE_SIZE						*
 *	ML 3/7/2007 QA70-9451 SET_LINKS_TRANSPOSED_ETC								*
 *	YuI 03/30/07 QA70-9523 BOXCHART_UPDATE_AFTER_SOURCE_DATA_UPDATE				*
 *	RVD 10/26/2007 v8.0735 qa7-10554 OC_DATA_STYLES								*
 *	CPY 11/09/2007 NLFIT_REPORT_NEED_BETTER_RESCALE_CONTROL						*
 *	RVD 11/29/2007 v8.0758 WKS_STYLES_MENU_TRANSLATE							*
 *	ML 12/4/2007 QA70-10624 OC_GETTING_INFO_ABOUT_SWAPPED_POLAR_FROM_DATAPLOT	*
 *	YuI 12/12/07 EXPOSE_DATA_MARKERS_TO_OC										*
 *	RVD 1/21/2008 qa70-10950 v8.0790 TRANSPOSE_WKS_TABLE						*
 *	ML 2/6/2008 SPECIAL_GROBJ_COLLECTIONS										*
 *	CPY FISHER 3/10/2008 QA70-11233 TRI_CONTOUR_LINES_ACCESS_FROM_OC			*
 *	ML 3/12/2008 GETTING_CONTOURS_DATA											*
 *	ML 7/8/2008 RETURN_INDICES_OF_ALL_ADDED_PLOTS_WHEN_ADDING_FROM_DATARANGE	*
 *	YuI 09/29/08 QA70-12265 CLEANUP_AND_ADDITIONAL_OC_INTERFACE_TO_GET_DATA_POINTS*
 *	YuI 12/04/08 QA70-12159 DATA_MARKERS_IN_WIZARD_PROBLEM						*
 *	Folger 12/19/08 QA80-12815 v8.0988c SUPPORT_GET_DATA_POINTS_BY_RECT_MADE_OF_TWO_DOUBLE_POINTS
 *	ML 12/19/2008 QA70-12802 SETTING_LEVELS_COLORS_TO_COLORMAP_OC_COM			*
 *	RVD 12/30/2008 qa70-12882 v8.0993 AXIS_LAYER_ICONS_COLOR					*
 *	Hong 01/06/09 QA80-12852 v8.993e CURVE_TRANSLATE_NEED_TO_CREATE_SPEEDMODE_DATA_TO_SPEEDUP
 *	Kyle 01/12/2009 QA80-12943 v8.0995c ADD_METHOD_TO_GET_AND_SET_LAYER_BORDER_SYTLE
 *	RVD 3/13/09 QA70-13282 GET_GROUPPLOT_FROM_DATAPLOT							*
 *	Folger 03/20/09 QA80-13326 SUPPORT_ACCESS_AXIS_POSITION_IN_OC				*
 *	Folger 04/10/09 QA80-13420 ACCESS_AXIS_LABEL_TYPE_AND_FORMAT_FROM_OC		*
 *	Folger 06/03/09 QA80-13713 GROBJ_NUMERIC_VARS_STORAGE_SUPPORT				*
 * Kenny 07/06/2009 QA80-13879 SUPPORT_RETRIEVING_INFO_OF_HIGHLIGHTED_CELL		*
 * Kenny 07/14/2009 QA80-13879-S2 OC_SUPPORT_HIGHLIGHTING_SPECIFIED_CELL		*
 *	Kenny 07/27/2009 QA80-14019 SUPPORT_ACCESS_AXIS_TITLE_OBJECT_IN_OC			*
 *	Folger 08/31/09 QA80-4588 OC_GET_LABEL_VALUES_BY_TYPE						*
 *	Fisher 09/01/09	QA80-14237	FAIL_TO_EXTRACT_TERNARY_CONTOUR_DATA			*
 *	Kenny 09/07/2009 QA81-14085 NEW_XF_TO_UPDATE_FIXED_FACTOR_AND_ALL_FONT_SIZE	*
 *	RVD 9/16/2009 qa70-14146 OC_MERGE_CELLS										*
 *	Kenny 09/25/2009 QA81-11561 WANT_LT_ACCESS_TO_DATA_INDEX_OF_DATA_MARKERS_IN_XF_MKS*
 *	Folger 10/10/09 QA80-14448 SET_GET_GROUP_STATES_IN_LAYER					*
 *	Folger 11/02/09 QA81-14571 OC_GRID_GETSELECTION_SUPPORT_LABEL_ROWS			*
 *	ML 11/26/2009 QA70-14743 SETTING_MODIFIERS_FROM_OC							*
 *	Sophy 12/11/2009 QA80-14686 DATAPLOT_GET_DATAPOINTS_NEED_TO_SKIP_MASKED_DATA*
 *	YuI 12/23/09 QA70-14885 PLOT_TO_DEPENDENT_SERIES_RELATION_BY_NAME			*
 *	Folger 12/25/09 QA81-14885 MORE_WORK_ON_SET_GET_RELATED_DATASET_FOR_OC		*
 *	Kyle 01/11/2010 QA80-14925 GRAPH_OBJECT_ALWAYS_REVERSE_VIDEO				*
 *	Folger 01/18/10 QA81-14981 GET_PAGE_AVERAGE_COORDINATES_NEEDED_IN_OC		*
 *	RVD 1/25/2010 QA70-15027 WORLD_LOGICAL_DOUBLE_PRECISION						*
 *	Sophy 2/22/2010 QA80-14832 QUICKFIT_SWITCH_TO_NLFIT_SHOULD_USE_EXISTING_DATAMARKER_WHEN_SELECT_RANGE
 *	Folger 04/15/10 QA81-15315 NLFIT_SHOULD_CHANGE_OUTPUT_GRAPH_AXIS_SCALE_IF_MANUAL
 *	Kyle 06/11/2010 ORG-294 EXPOSE_MOVE_OBJECT_TO_OC							*
 *	Kyle 07/14/2010 ORG-571-S1 NO_SELECT_EFFECT_FOR_GRAPH_OBJECT				*
 *	Kyle 07/16/2010 ORG-584-S2 PREVENT_DB_CLICK_ON_GRAPH_OBJECT					*
 *	Folger 08/04/10 ORG-705 COPY_COLORMAP_FORMAT_CONTEXT_MENU					*
 *	EJP 2010-09-22 ORG-1134 OC_FAST_ACCESS_TO_CELL_COLORS						*
 *	Folger 10/20/2010 ORG-1295 EXPOSE_GRID_PUTLABELSBYTYPES_TO_OC				*
 *	Kit 10/21/2010 RSRCH-29	REMOVE_TEXT_AT_BOTTOM_OF_IMAGE						*
 *------------------------------------------------------------------------------*/
#ifndef _GRAPH_H
#define _GRAPH_H

#include <common.h> // must always include this, has printf etc

#ifndef _STRING_H
#include <string.h> // most likely you will also need strings
#endif // _STRING_H

#include <OC_const.h> // consts used in Origin internal functions
#include <oPlotIDs.h> // IDM_PLOT_* ids and related const

#ifndef _DATA_H
#include <data.h>
#endif // _DATA_H

#include <ORgObj.h>

/// ML 12/17/2004 PROGRAMMATICALLY_PUTTING_A_REPORT_TABLE_INTO_A_GRAPH
#if  _OC_VER >= 0x0800

//class OperationBase;

///Comments last updated by Joseph on 03/12/2007
/**+
http://ocwiki.originlab.com/index.php?title=Category:Grid_(class)
*/
class  Grid :	public OriginObject
{
public:
	// Comments last updated by Jasmine on 01/03/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-Grid
	*/
	Grid();
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-Grid
	*/
	Grid(Grid& grid);


	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-GetOwner
	*/
	void	GetOwner(OriginObject& oo);
	
	// Comments last updated by Iris 07/22/2008, added #
	/**#
	*/
	int		Find(TreeNode &treeQuery, TreeNode &treeResult, TreeNode &ptreeOptional = NULL);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-Expand
	*/
	BOOL	Expand(BOOL bExpand);
	
	/**#
	*/
	int		BuildQueryTree(TreeNode &treeQuery);

	/**#
	*/
	BOOL	CopyFootnote();

	/// ML 12/16/2004 UNIFIED_GRID_CONTEXT_MENU_HANDLING
	/**#
	*/
	BOOL	CopyTable();

	/// ML 1/22/2007 QA70-9189 MAKING_A_FLAT_SHEET_WITH_LINKS_ONLY_AND_IN_DATA_AS_WELL_AS_LABELS_AREA_OUT_OF_A_WHOLE_SOURCE_TABLE
	/**$
			It makes a copy of 'this' Grid object into the destination flat sheet. Values are copied as macros. The column labels
			of the source are copied into the column labels of the destination (the count of the column labels in the destination
			is properly adjusted to match that of the source). The row labels of the source are put into the data columns of the
			destination.
	*/
	/// ML 3/7/2007 QA70-9451 SET_LINKS_TRANSPOSED_ETC
	//BOOL	MakeCopyWithLinks(Worksheet &wksDest);
	BOOL	MakeCopyWithLinks(Worksheet &wksDest, BOOL bSetTransposed = FALSE);
	/// end SET_LINKS_TRANSPOSED_ETC
	/// end MAKING_A_FLAT_SHEET_WITH_LINKS_ONLY_AND_IN_DATA_AS_WELL_AS_LABELS_AREA_OUT_OF_A_WHOLE_SOURCE_TABLE


	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-GetNumChildGrids
	*/
	int		GetNumChildGrids();

	/// Last updated comments by Iris 03/03/2008. Not worked, example return false in IR816. 
	/**#
		To check if the grid is in worksheet report
	Example1:
		void Grid_IsInWksReport_ex1()
		{
			Worksheet wks = Project.ActiveLayer();
			if(wks && wks.GetSystemParam(0) & WP_SHEET_HIERARCHY)
			{
				Grid 	gg;
				gg.Attach(wks);			
				bool bRet = gg.IsInWksReport(); //should return true
			}
		}
	Return:
		true if the grid is in worksheet report, else false
	*/
	BOOL	IsInWksReport();
	/// end UNIFIED_GRID_CONTEXT_MENU_HANDLING
	
	/**#
	*/
	BOOL	Attach(DataRange &rngOutput, int idTable);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-Attach
	*/
	BOOL	Attach(Datasheet& wks, int nTable = -1);

	/// ML 12/21/2004 GRID_TABLE_PROPERTIES
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-ShowHeaders
	*/
	BOOL	ShowHeaders(BOOL bShow, BOOL bUndo = FALSE, BOOL bColHeaders = true);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-IsHeadersShown
	*/
	BOOL	IsHeadersShown(BOOL bColHeaders);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-ShowGridLines
	*/
	BOOL	ShowGridLines(BOOL bVert, BOOL bShow, BOOL bUndo = FALSE);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-IsGridLinesShown
	*/
	BOOL	IsGridLinesShown(BOOL *pbVert, BOOL *pbHoriz);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-ShowLabels
	*/
	BOOL	ShowLabels(UINT nType, BOOL bShow = TRUE, BOOL bUndo = FALSE, BOOL bColLabels = true);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-IsLabelsShown
	*/
	BOOL	IsLabelsShown(UINT nType, BOOL bColLabels = true);

	/// RVD 1/21/2008 qa70-10950 v8.0790 TRANSPOSE_WKS_TABLE
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-SetTranspose
	*/
	BOOL	SetTranspose(BOOL bSet, BOOL bUndo = FALSE);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-IsTransposed
	*/
	BOOL	IsTransposed();
	/// end TRANSPOSE_WKS_TABLE

	/// RVD 9/16/2009 qa70-14146 OC_MERGE_CELLS
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-MergeCells
	*/
	BOOL	MergeCells(const ORANGE& rng, BOOL bLabels = FALSE);
	/// end OC_MERGE_CELLS
	
	/// ML 8/7/2006 GET_SET_SHOW_LABELS_BY_ARRAY_OF_TYPES
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-SetShowLabels
	*/
	BOOL	SetShowLabels(vector<int> &vnTypes, BOOL bUndo = FALSE, BOOL bCol = true);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-SetShowLabels
	*/
	BOOL	SetShowLabels(BOOL bUndo = FALSE, int nLabel1 = -1, int nLabel2 = -1, int nLabel3 = -1, int nLabel4 = -1, int nLabel5 = -1, BOOL bCol = true);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-GetShowLabels
	*/
	BOOL	GetShowLabels(vector<int> &vnTypes, BOOL bCol = true);
	/// end GET_SET_SHOW_LABELS_BY_ARRAY_OF_TYPES
	/// end GRID_TABLE_PROPERTIES

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-GetUserDefinedLabelNames
	*/
	BOOL	GetUserDefinedLabelNames(StringArray& arr, BOOL bCol = TRUE) const;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-SetUserDefinedLabelNames
	*/
	BOOL	SetUserDefinedLabelNames(const StringArray& arr, BOOL bCol = TRUE);

	/// RVD 10/26/2007 v8.0735 qa7-10554 OC_DATA_STYLES
	/**#
	*/
	BOOL	GetCellTextColors(vector<uint>& vcrf, int nCol, int r1=0, int r2=-1) const;
	/// Last updated by Sim, 08-01-2008 need # for each method
	/**#
	*/
	BOOL	SetCellTextColors(const vector<uint>& vcrf, int nCol, int r1=0, int r2=-1);
	/// end OC_DATA_STYLES

	/// EJP 2010-09-22 ORG-1134 OC_FAST_ACCESS_TO_CELL_COLORS
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-CellBkColor
	*/
	BOOL CellBkColor(DWORD& dwColor, int nRow, int nCol, BOOL bGet=TRUE, BOOL bLabels=FALSE);
	/// Last updated by Sim, 08-01-2008 need # for each method
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-CellTextColor
	*/
	BOOL CellTextColor(DWORD& dwColor, int nRow, int nCol, BOOL bGet=TRUE, BOOL bLabels=FALSE);
	/// end OC_FAST_ACCESS_TO_CELL_COLORS

	/**#
	*/
	OperationBase	*GetOperation();

	/// RVD 2/16/2005 QA70-7289 v8.0185 WKS_THEME_SUPPORT
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-Styles
	*/
	BOOL	Styles(int r1, int c1, int r2, int c2, vector<string>& vs, BOOL bGet);
	/// end WKS_THEME_SUPPORT

	/// ML 2/21/2005 DELETING_INSERTING_ROWS_IN_TABLE_WITH_LINKS
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-Delete
	*/
	BOOL	Delete(BOOL bUndo = FALSE);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-Insert
	*/
	BOOL	Insert(BOOL bUndo = FALSE);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-CanDelete
	*/
	BOOL	CanDelete();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-CanInsert
	*/
	BOOL	CanInsert();
	/// end DELETING_INSERTING_ROWS_IN_TABLE_WITH_LINKS

	/// ML 2/22/2005 GETTING_GRIDTABLE_NID
	/**#
	*/
	UINT	GetID();

	/**#
	*/
	string	GetLongName();

	/// end GETTING_GRIDTABLE_NID

	/// RVD 4/7/2006 QA70-8609 v8.0387 TABLE_GRID_BORDERS
	/**#
	*/
	int		GetSystemThemeType(BOOL& bRelativeStyle);
	/// end TABLE_GRID_BORDERS

	/// RVD 11/29/2007 v8.0758 WKS_STYLES_MENU_TRANSLATE
	/**#
		 It return nice human readable localized string for a given named style lpcszNamedStyle.
	*/
	string	TranslateNamedStyle(LPCTSTR lpcszNamedStyle);
	/// end WKS_STYLES_MENU_TRANSLATE

	/// RVD 2/28/2005 QA70-7446 v8.0199 GRID_NAMED_STYLES
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-GetSelectedRange
	*/
	BOOL	GetSelectedRange(int &r1, int &c1, int &r2, int &c2);

	/// Kenny 07/06/2009 QA80-13879 SUPPORT_RETRIEVING_INFO_OF_HIGHLIGHTED_CELL
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-GetCurrentCell
	*/
	int		GetCurrentCell(int& nRow, int& nCol, BOOL bTranslate=true);
	/// End QA80-13879 SUPPORT_RETRIEVING_INFO_OF_HIGHLIGHTED_CELL

	/// Kenny 07/14/2009 QA80-13879-S2 OC_SUPPORT_HIGHLIGHTING_SPECIFIED_CELL
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-SetCurrentCell
	*/
	BOOL	SetCurrentCell(int nRow, int nCol, BOOL bTranslate = TRUE);
	/// End QA80-13879-S2 OC_SUPPORT_HIGHLIGHTING_SPECIFIED_CELL

	///------ Folger 08/31/09 QA80-4588 OC_GET_LABEL_VALUES_BY_TYPE
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-GetLabelsByType
	*/
	int		GetLabelsByType(StringArray& arr, int nType, BOOL bCol = TRUE);
	///------ End OC_GET_LABEL_VALUES_BY_TYPE

	///------ Folger 10/20/2010 ORG-1295 EXPOSE_GRID_PUTLABELSBYTYPES_TO_OC
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-PutLabelsByType
	*/
	BOOL	PutLabelsByType(StringArray& arr, int nType, BOOL bCol = TRUE);
	///------ End EXPOSE_GRID_PUTLABELSBYTYPES_TO_OC

	//Comments updated by Joseph 07/30/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-GetSelection
	*/
	///------ Folger 11/02/09 QA81-14571 OC_GRID_GETSELECTION_SUPPORT_LABEL_ROWS
	//int	GetSelection(vector<int> &vR1, vector<int> &vC1, vector<int> &vR2, vector<int> &vC2); 
	int	GetSelection(vector<int> &vR1, vector<int> &vC1, vector<int> &vR2, vector<int> &vC2, BOOL bCheckLabelRows = FALSE); 
	///------ End OC_GRID_GETSELECTION_SUPPORT_LABEL_ROWS
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-SetSelection
	*/
	BOOL	SetSelection(vector<int> &vR1, vector<int> &vC1 = NULL, vector<int> &vR2= NULL, vector<int> &vC2 = NULL, BOOL bData = true);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-FrozenRows
	*/
	int		FrozenRows;

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-FrozenCols
	*/
	int		FrozenCols;

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-FixedRows
	*/
	int		FixedRows;

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-FixedCols
	*/
	int		FixedCols;

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-Rows
	*/
	int		Rows;

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Grid-Cols
	*/
	int		Cols;
	/// end GRID_NAMED_STYLES
};

#endif //_OC_VER >= 0x0800

/// end PROGRAMMATICALLY_PUTTING_A_REPORT_TABLE_INTO_A_GRAPH

// Comments last updated by ER on 12/09/04
/**+
http://ocwiki.originlab.com/index.php?title=Category:Layer_(class)
*/
class Layer : public OriginObject
{
public:
	
	// Comments last updated by ER on 12/09/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Layer-Layer
	*/
	Layer();
	
	
	// Comments last updated by ER on 12/13/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Layer-Layer
	*/
	Layer(Layer & layer);

	// Comments last updated by ER on 12/13/04
	/**$
		Returns the GraphObject in the layer by index.
		GraphObjects are text labels, rectangles, lines, arrows, etc, which
		can be drawn inside graphs, worksheets, and layouts,
	Keywords:
		GraphLayer
	Example1:
		void Layer_GraphObject_ex1()
		{
			// Call this function with a graph layer active
			//
			// Create a Layer object and attach it to the active layer of the graph
			GraphLayer	gly	= Project.ActiveLayer();
			if( gly.IsValid() )
			{
				// Get the first graph object contained in the graph layer
				GraphObject grobj;
				grobj = gly.GraphObjects( 0 );
				if( grobj.IsValid() )
				{
					// Get name of the graph object and report
					printf( "Name of the first graph object in layer is: %s\n", grobj.GetName() );
				}
				else
					out_str( "No graph objects found in graph layer" );
			}
			else
				out_str( "No active graph layer found" );
		}
	Parameters:
		index = [input] index of the GraphObject to be returned
	Return:
		GraphObject in the layer whose index was specified
	*/	
	GraphObject	GraphObjects(int index);
	
	// Comments last updated by ER on 12/13/04
	/**$
		Returns the GraphObject with the specified name from the layer.
		GraphObjects are text labels, rectangles, lines, arrows, etc, which
		can be drawn inside graphs, worksheets, and layouts,
	Example1:
		void Layer_GraphObject_ex2()
		{
			// Call this function with a graph layer active
			//
			GraphLayer	gly = Project.ActiveLayer();
			if( gly.IsValid() )
			{
				// Get the GraphObject named "YL" which is the Y axis title
				// in a default graph layer
				GraphObject grobj;
				grobj = gly.GraphObjects( "YL" );
				if( grobj.IsValid() )
				{
					// Report the object type
					printf("GraphObject is of type: %s\n", grobj.GetObjectType() );
				}
				else
					out_str( "Could not find Y axis title object" );
			}
			else
				out_str( "No graph layer active" )
		}
	Parameters:
		lpcszName = [input] pointer to the string containing the name of the GraphObject
	Return:
		GraphObject with the specified name from the layer.
	*/
	GraphObject	GraphObjects(LPCSTR lpcszName);

	// Comments last updated by ER on 12/13/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Layer-GetPage
	*/
	Page		GetPage();
	
	// Comments last updated by Joseph on 07/30/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Layer-Detach
	*/
	//void		Detach();  //CPY 8/21/08 moved to base class

	// Comments last updated by ER on 12/13/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Layer-RemoveGraphObject
	*/
	BOOL		RemoveGraphObject(int index);
	
	// Comments last updated by ER on 12/13/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Layer-RemoveGraphObject
	*/
	BOOL		RemoveGraphObject(LPCSTR lpcszName);		


	// Comments last updated by ER on 12/13/04	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Layer-GraphObjects
	*/
	Collection<GraphObject> GraphObjects;

	/// ML 2/6/2008 SPECIAL_GROBJ_COLLECTIONS
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Layer-GetSpecialGraphicObjectsCollection
	*/
	BOOL		GetSpecialGraphicObjectsCollection(Collection<GraphObject> &coll, LPCSTR lpcszPrefix);
	/// end SPECIAL_GROBJ_COLLECTIONS

	
	// Comments last updated by ER on 12/13/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Layer-GetIndex
	*/
	int			GetIndex();

	// Comments last updated by ER on 12/14/04
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Layer-LT_execute
	*/
	BOOL	LT_execute(LPCSTR lpcszstr, int wCntrl = 0);

	#if  _OC_VER >= 0x0750
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Layer-GetSystemParam
	*/
	DWORD GetSystemParam(int nParamType);
	#endif //_OC_VER >= 0x0750
	
	#if  _OC_VER >= 0x0800
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Layer-CreateGraphObject
	*/
	GraphObject	CreateGraphObject(int nType, LPCSTR lpcszName = NULL, DWORD dwCntrl = 0);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Layer-CreateLinkTable
	*/
	GraphObject	CreateLinkTable(LPCSTR lpcszName = NULL, Worksheet& wks = NULL, int nTable = -1, DWORD dwCntrl = 0);

	/**#
	*/
	/// ML 3/12/2008 GETTING_CONTOURS_DATA
	//int		UpdateROIObject(LPCSTR lpcszName, TreeNode& tr = NULL);
	int		CreateUpdatePolypolygon(LPCSTR lpcszName, TreeNode& tr = NULL, LINEPROPS *pstLineProps = NULL, BOOL bROI = FALSE);
	/// end GETTING_CONTOURS_DATA
	
	/**#
	*/
	Collection<GraphObject> ROIObjects;

	/**#
	Get the data (gray scale levels) of a bitmap graphic object.
	Return:
		TRUE if the data was obtained else FALSE.
	Parameters:
		lpcszImageName =[input] constant pointer to a string contianing the name of the bitmap graphic object
		mat =[output] the matrix to receive the data
		nGrayScaleBits =[input] the number of gray scale levels to convert a non-gray scale image to before getting the data
	Example:
	*/
	BOOL GetImageData(LPCSTR lpcszImageName, matrixbase& mat, int nGrayScaleBits=8);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Layer-Delete
	*/
	BOOL	Delete(DWORD dwCntrl = OCD_UNDO);
	
	/**#
	*/
	Layer	Clone();
	
	/**#
	*/
	int		HitTestPoint(point pt, point  *lpPtOut = NULL, uint dwCtrl =0);
	
	/**#
	*/
	BOOL	SetTable(LPCTSTR lpcszName, const Grid &gridtblSource, Grid &gridtblResult = NULL, OriginObject& obj = NULL);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Layer-WorldToPage
	*/
	BOOL	WorldToPage(int &nXPage, int &nYPage, double rXWorld, double rYWorld);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Layer-PageToWorld
	*/
	BOOL	PageToWorld(double &rXWorld, double &rYWorld, int nXPage, int nYPage);

	/// RVD 1/25/2010 QA70-15027 WORLD_LOGICAL_DOUBLE_PRECISION
	/**#
	Convert world to logical coordinates.
	Return:
		0 if success.
	Parameters:
		pWorld =[input] pointer to world coordinates buffer
		pView =[output] pointer to view coordinates buffer
		nCount = [input] the number of values in the buffer
		nDim = [input] optional dimension specifier. 0=all dimensions, 1=only 1st, 2=only 2nd dimension
	Example:
		void test_WorldView()
		{
			GraphLayer gl = Project.ActiveLayer();
			if( gl )
  			{
  				double world[2];
  				double view[2];
  				world[0] = 3.123456789012345;
  				world[1] = 7.123456789012345;
  				int nError = gl.WorldToView(world, view, 2);
  				nError = gl.ViewToWorld(view, world, 2);
			}
		}

		void test_WorldView1D(int nDim=1)
		{
			GraphLayer gl = Project.ActiveLayer();
			if( gl )
  			{
  				double dw = 3.123456789012345;
  				double dv;
  				double dd;
  				int nError = gl.WorldToView(&dw, &dv, 1, nDim);
  				nError = gl.ViewToWorld(&dv, &dd, 1, nDim);
  				double diff = dd - dw;
			}
		}
	*/
	BOOL	WorldToView(const double* pWorld, double* pView, int nCount, int nDim = 0);
	/**#
	Convert logical to world coordinates.
	Return:
		0 if success.
	Parameters:
		pView =[input] pointer to view coordinates buffer
		pWorld =[output] pointer to world coordinates buffer
		nCount = [input] the number of values in the buffer
		nDim = [input] optional dimension specifier. 0=all dimensions, 1=only 1st, 2=only 2nd dimension
	Example:
		see WorldToView
	*/
	BOOL	ViewToWorld(const double* pView, double* pWorld, int nCount, int nDim = 0);
	/// end WORLD_LOGICAL_DOUBLE_PRECISION

	/// TD 12-12-05 QA70-8061 EXTEND_PASSWORD_PROTECTION_TO_PAGE_AND_PROJECT
	///**
	//*/
	//BOOL	Lock(LPCSTR lpcszPassword, DWORD dwCtrl = PLC_DATA);
	//
	///**
	//*/
	//BOOL	Unlock(LPCSTR lpcszPassword, DWORD dwCtrl = PLC_DATA);
	/// end EXTEND_PASSWORD_PROTECTION_TO_PAGE_AND_PROJECT
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Layer-UnitsConvert
	*/
	BOOL UnitsConvert(int nUnitsTo, double* pVals, int nUnitsFrom = -1);	 //--- CPY 3/2/2007 QA70-9433 CONVERT_LAYER_AREA
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Layer-GetPosition
	*/
	int GetPosition(double* pVals = NULL);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Layer-SetPosition
	*/
	/// EJP 2007-03-14 v8.0582 QA70-9465 ADD_UNDO_ARG_TO_METHODS
	///BOOL SetPosition(const double* pVals, int nUnits = -1);
	BOOL SetPosition(const double* pVals, int nUnits = -1, DWORD dwCtrl = OCD_ASK);
	/// end ADD_UNDO_ARG_TO_METHODS
	
	
	#endif //_OC_VER >= 0x0800

};

// Comments last updated by ER on 12/14/04
/**+
http://ocwiki.originlab.com/index.php?title=Category:Layout_(class)
*/
class Layout : public Layer
{
public:
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Layout-Layout
	*/
	Layout(LPCSTR layoutname);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Layout-Layout
	*/
	Layout(Layer & layer);	
	
};

/**+
http://ocwiki.originlab.com/index.php?title=Category:Scale_(class)
*/
class Scale : public OriginObject
{
public:
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Scale-Scale
	*/
	Scale();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Scale-Scale
	*/
	Scale(Scale & scale);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Scale-From
	*/
	double 	From;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Scale-To
	*/
	double 	To;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Scale-Inc
	*/
	double 	Inc;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Scale-Type
	*/
	int 	Type;

	///------ Folger 04/15/10 QA81-15315 NLFIT_SHOULD_CHANGE_OUTPUT_GRAPH_AXIS_SCALE_IF_MANUAL
	/**#
	*/
	int		Rescale;
	///------ End NLFIT_SHOULD_CHANGE_OUTPUT_GRAPH_AXIS_SCALE_IF_MANUAL
};

/**+
http://ocwiki.originlab.com/index.php?title=Category:GraphLayer_(class)
*/
class GraphLayer : public Layer
{
public:
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-GraphLayer
	*/
	GraphLayer(LPCSTR lpcszWinName, int nLayerNum=-1);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-GraphLayer
	*/
	GraphLayer(Layer & layer);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-Attach
	*/
	BOOL Attach(LPCSTR lpcszWinName, int nLayerNum=-1);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-AddPlot
	*/
	int AddPlot(Curve& cData, int nPlotID = IDM_PLOT_UNKNOWN, uint dwCntrl = GAP_USE_TEMPLATE);
	
	/**
		The method retrieves the layer contents in form of a tree.
	*/
#if  _OC_VER > 0x0703
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-GetLayerContents
	*/
	BOOL  GetLayerContents(TreeNode &tr, DWORD dwCtrl = 0);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-AddPlots
	*/
	int		AddPlots(TreeNode &tr, DWORD dwOptions = 0);
	
#endif	// _OC_VER

#if  _OC_VER >= 0x0800
	/// Last updated comments by Iris 03/06/2008
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-AddPlot
	*/
	int		AddPlot(DataPlot &dp, DWORD dwOptions = ADDPLTPFROMPLT_ERRORBAR);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-AddPlot
	*/
	/// ML 7/8/2008 RETURN_INDICES_OF_ALL_ADDED_PLOTS_WHEN_ADDING_FROM_DATARANGE
	//int		AddPlot(const DataRange& dr, int nPlotID = IDM_PLOT_SCATTER, uint dwCntrl = GAP_GROUP_PLOTS | GAP_USE_TEMPLATE | GAP_ALLOW_DUPLICATE_COL);
	int		AddPlot(const DataRange& dr, int nPlotID = IDM_PLOT_SCATTER, uint dwCntrl = GAP_GROUP_PLOTS | GAP_USE_TEMPLATE | GAP_ALLOW_DUPLICATE_COL,
						int *pnAddtionalAddedPlots = NULL, int nAddtionalAddedPlotsBufferSize = 0);
	/// end RETURN_INDICES_OF_ALL_ADDED_PLOTS_WHEN_ADDING_FROM_DATARANGE
	
#endif	// _OC_VER

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-AddPlot
	*/
	int AddPlot(Curve& cData, StyleHolder& style);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-AddPlot
	*/
	int AddPlot(Worksheet& wks, int nPlotID = IDM_PLOT_UNKNOWN);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-AddErrBar
	*/
	int AddErrBar(Curve& cData, Column &colErrBar);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-AddErrBar
	*/
	int AddErrBar(Curve& cData, Dataset &dsErrBar);
	
	// Comments last updated by Iris 07/22/2008
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-AddXErrBar
	*/
	int AddXErrBar(Curve& cData, Column &colXErrBar);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-AddXErrBar
	*/
	int AddXErrBar(Curve& cData, Dataset &dsXErrBar);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-AddLabelPlot
	*/
	int AddLabelPlot(Curve& cData, Column &colLabel);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-AddLabelPlot
	*/
	int AddLabelPlot(Curve& cData, Dataset &dsLabel);
	
#if  _OC_VER > 0x0703
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-AddPlot
	*/
	int	AddPlot(MatrixObject& matObj, int nPlotID = IDM_PLOT_MATRIX_IMAGE);
#endif // _OC_VER

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-Rescale
	*/
	BOOL	Rescale(DWORD dwCntrl = 0, int* lpnOutcome = NULL);

	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-GetCoordinateType
	*/
	UINT GetCoordinateType(DWORD *pnMoreInfo = NULL);	  /// TD ML 05-04-2010 ORG-74 POLAR_AND_FUNCTION_DIALOGBAR_IMPROVEMENT (Added arg  pnMoreInfo)

	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-GroupPlots
	*/
	BOOL	GroupPlots(int nIndexStart, int nIndexEnd = -1);
	
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-UngroupPlots
	*/
	BOOL	UngroupPlots(int nIndex = -1);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-ClearMarkers
	*/
	BOOL  	ClearMarkers(int nIndex = -1, DWORD dwOpts=OCD_ASK|OCD_UNDO);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-GetSparkline
	*/
	bool GetSparkline(PictureHolder &phDest, LPCSTR lpcszType, int nRes, int nSpark, DWORD dwOptions);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-X
	*/
	Scale X;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-Y
	*/
	Scale Y;
	
	/**$
		Gets an arbitrary DataPlot in layer.
	Parameters:
		index = 0-offset index of the data plot in layer.
	Returns:
		the index'th DataPlot.
	Example1:
		// After the function executes, the data plot will show
		// only the data points from 5 to 10.
		void	GraphLayer_DataPlots_ex1()
		{
			Worksheet wks;
			wks.Create("origin");
			Dataset ds1(wks,0);
			Dataset ds2(wks,1);
			ds1.Data(1,20,1);
			ds2.Normal(20);
			GraphPage gp;
			gp.Create("origin");
			GraphLayer gl(gp.GetName(), 0);
			gl.AddPlot(wks);
			
			if(gl)
			{			
				// Get the first data plot in the layer:
				DataPlot		dp = gl.DataPlots(0);
			
				// Change the display range of the data plot to
				// show only points from 5 to 10:
				dp.SetRange(5, 10);
			}
		}
	*/
	DataPlot					DataPlots(int index = -1);
	
	/**$
		Gets an arbitrary DataPlot in layer.
	Parameters:
		lpcszName = the name of the dataset that the desired DataPlot should contain.
	Returns:
		the DataPlot.
	Example2:
		void	GraphLayer_DataPlots_ex2()
		{
			Worksheet wks1;
			wks1.Create("origin");
			Dataset ds1(wks1,0);
			Dataset ds2(wks1,1);
			ds1.Data(1,20,1);
			ds2.Normal(20);
			GraphPage gp;
			gp.Create("origin");
			GraphLayer gl(gp.GetName(), 0);
			gl.AddPlot(wks1);
			
			if(gl)
			{
				Worksheet wks = Project.WorksheetPages(0).Layers(0);
				if(wks)
				{			
					// Get the data plot in the layer which contains dataset of column B:
					Dataset 		ds(wks, 1);
					DataPlot		dp = gl.DataPlots(ds.GetName());
				
					// Change the display range of the data plot to show only points from 5 to 10:
					dp.SetRange(5, 10);
				}
			}
		}
	*/
	DataPlot					DataPlots(LPCSTR lpcszName);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-RemovePlot
	*/
	BOOL						RemovePlot(int nIndex);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-RemovePlot
	*/
	BOOL						RemovePlot(DataPlot& dp);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-DataPlots
	*/
 	Collection<DataPlot>	 	DataPlots;

	/**$
		Gets an arbitrary StyleHolder in layer.
	Parameters:
		index = 0-offset index of the StyleHolder in layer.
	Returns:
		the index'th StyleHolder.
	Example1:
		void	GraphLayer_StyleHolders_ex1()
		{
			GraphPage gp;
			gp.Create("origin");
			GraphLayer		gl(gp.GetName(),0);
			
			if(gl)
			{			
				StyleHolder		sh;
				
				// Get the first style holder:
				sh = gl.StyleHolders(0);
				
				// Display its name:
				out_str(sh.GetName());
			}
		}
	*/
	StyleHolder	StyleHolders(int index);
	
	/**$
		Gets an arbitrary StyleHolder in layer.
	Parameters:
		lpcszName = the name of the style holder in layer (the name of a style holder
					starts with an underscore followed by a number
					indicating the plot type).
	Returns:
		the StyleHolder.
	Example2:
		// For this example to run, a graph window must exist in the project.
		// Make sure that you use the line-symbol plot template or graph, because
		// the function tries to access the style holder with the name "_202" which
		// corresponds to the line-symbol plot type.
		void	GraphLayer_StyleHolders_ex2()
		{
			// Create and attach a graph layer from current Graph:
			GraphLayer		gl = Project.ActiveLayer();
			
			if(gl)
			{			
				StyleHolder		sh;
				
				// Get the style holder "_202":
				sh = gl.StyleHolders("_202");
				
				// Display its name:
				out_str(sh.GetName());
			}
		}
	*/
	StyleHolder	StyleHolders(LPCSTR lpcszName);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-StyleHolders
	*/
	Collection<StyleHolder> StyleHolders;

#if _OC_VER > 0x0703
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-SetDataMarkers
	*/
	BOOL	SetDataMarkers(int i1, int i2);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-GetDataMarkers
	*/
	BOOL	GetDataMarkers(int& i1, int& i2);

	/**$
	*/
	BOOL	SetMarkerLines(vector& vPos, BOOL bShow = TRUE, BOOL bVertical = TRUE);

	/**$
	*/
	int		MoveMarkerLine(double dNewPos, int nIndex, BOOL bVertical = TRUE);

	/**$
	*/
	int		SetShowMarkerLine(BOOL bShow, int nIndex, BOOL bVertical = TRUE);

	/// RVD 12/30/2008 qa70-12882 v8.0993 AXIS_LAYER_ICONS_COLOR
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphPage-AxisLayerIcons
	*/
	DWORD		IndicatorTextColor;
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphPage-AxisLayerIcons
	*/
	DWORD		IndicatorBkColor;
	/// end AXIS_LAYER_ICONS_COLOR

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-XAxis
	*/
	Axis	XAxis;

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-YAxis
	*/
	Axis	YAxis;

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-ZAxis
	*/
	Axis	ZAxis;

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-Groups
	*/
	GroupPlot	Groups(int nIndex);
#endif //	_OC_VER > 0x0703
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-ConvertByAxis
	*/
	BOOL		ConvertByAxis(double *prVals, int nSize, int nAxis, BOOL bForward, double *prValsOptnlDest = NULL);
	
	///Kyle 01/12/2009 QA80-12943 v8.0995c ADD_METHOD_TO_GET_AND_SET_LAYER_BORDER_SYTLE
	/**$
		Gets border style of the layer
	Parameters:
		nStyle = [output] the style of the layer based on nBase.
		nBase  = [input]  base of nStyle
	Returns:
		true if Border Style valid.
	Example:
		void	GraphLayer_GetBorderStyle_ex1()
		{
			GraphLayer		gl = Project.ActiveLayer();
			if(gl)
			{
				int nStyle;
				
				if( gl.GetBorderStyle(nStyle, 0))
					printf("Layer Border Style(based on 0) is: %d\n", nStyle);
				else
					out_str("Layer Border Style invalid");
			}
		}
	*/
	BOOL GetBorderStyle(int& nStyle, int nBase = 0);
	/**$
		Sets border style of the layer
	Parameters:
		nStyle = [input]  the style based on nBase, 0 based Style see enumeration BORDERSTYLE in OC_const.h
		nBase  = [input]  base of nStyle
		bUndo  = [input]  supports undo
	Returns:
		true if success, otherwise false
	Example:
		void	GraphLayer_SetBorderStyle_ex1()
		{
			GraphLayer		gl = Project.ActiveLayer();
			if(gl)
			{
				int nStyle = BS_SHADOW;
				
				if( gl.SetBorderStyle(nStyle))
					out_str("success");
				else
					out_str("failed");
			}
		}
	*/
	BOOL SetBorderStyle(int nStyle, int nBase = 0, BOOL bUndo = false);
	///End ADD_METHOD_TO_GET_AND_SET_LAYER_BORDER_SYTLE

	/// Kenny 09/07/2009 QA81-14085 NEW_XF_TO_UPDATE_FIXED_FACTOR_AND_ALL_FONT_SIZE
	// Comments last updated by Kenny on 09/07/2009
	/**$
		Remarks:
			Get the scale elements related attributes of the layer
		Example1:
			int GetScaleElements_ex1()
			{
				GraphLayer		gl = Project.ActiveLayer();
				if(gl)
				{
					int		nScaleMode;
					double	dFixedFactor;
					BOOL bRet = gl.GetScaleElements(nScaleMode, dFixedFactor);
					ASSERT(bRet);
				}
				return 0;
			}
		Parameters:
			nScaleMode = [input] 0 means Scale With Layer Frame, 1 means Fixed Factor mode.
			dFixedFactor = [input] The fixed factor value
		Return:
			Return TRUE if success, or FALSE if failed.
	*/
	BOOL GetScaleElements(int& nScaleMode, double& dFixedFactor);

	// Comments last updated by Kenny on 09/07/2009
	/**$
		Remarks:
			Set the scale elements related attributes of the layer
		Example1:
			int SetScaleElements_ex1()
			{
				GraphLayer		gl = Project.ActiveLayer();
				if(gl)
				{
					int		nScaleMode		= 1;
					double	dFixedFactor	= 0.8;
					BOOL bRet = gl.SetScaleElements(nScaleMode, dFixedFactor);
					ASSERT(bRet);
				}
				return 0;
			}
		Parameters:
			nScaleMode = [input] Specify the scale mode, 0 means Scale With Layer Frame, 1 means Fixed Factor mode.
			dFixedFactor = [input] The fixed factor value, only used when nScaleMode is 1 and ignored when nScaleMode is 0
		Return:
			Return TRUE if success, or FALSE if failed.
	*/
	BOOL SetScaleElements(int nScaleMode, double dFixedFactor = 1.0);
	/// End QA81-14085 NEW_XF_TO_UPDATE_FIXED_FACTOR_AND_ALL_FONT_SIZE

	///------ Folger 10/10/09 QA80-14448 SET_GET_GROUP_STATES_IN_LAYER
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphLayer-DataplotsGrouping
	*/
	int    DataplotsGrouping(vector<int> &vn, BOOL bSet = TRUE);
	///------ End SET_GET_GROUP_STATES_IN_LAYER
};

/**+
http://ocwiki.originlab.com/index.php?title=Category:GraphObject_(class)
*/
class GraphObject : public OriginObject
{
public:
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphObject-GraphObject
	*/
	GraphObject();
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphObject-GraphObject
	*/
	GraphObject(GraphObject &goOriginal);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphObject-X
	*/
	double	X;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphObject-Y
	*/
	double	Y;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphObject-XTemp
	*/
	double	XTemp;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphObject-YTemp
	*/
	double	YTemp;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphObject-GetTempBoundingBox
	*/
	BOOL	GetTempBoundingBox(FRECT* pRect, DWORD dwCntrl = 0);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphObject-DX
	*/
	double	DX;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphObject-DY
	*/
	double	DY;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphObject-Width
	*/
	int		Width;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphObject-Height
	*/
	int		Height;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphObject-Left
	*/
	int		Left;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphObject-Top
	*/
	int		Top;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphObject-Attach
	*/
	int		Attach;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphObject-Text
	*/
	string	Text;	
	
#if  _OC_VER < 0x0750
	/**
		The name of the graphic object. The name of each object can be seen by
		opening the "Label Control" dialog box (using the context menu on the object).
	Parameters:

	Returns:
		the name of the GraphObject. 
	Example1:
		void	GraphObject_GetName_ex1()
		{
			GraphPage gp;
			gp.Create("origin");
			GraphLayer		gl(gp.GetName(),0);
			GraphObject		grobj;
			
			// Loop over all the graphic objects in the layer and for each of them
			// display its name:
			foreach (grobj in gl.GraphObjects)
			{
				out_str(grobj.GetName());
			}
		}
	*/
	string	GetName();
#endif //_OC_VER < 0x0750
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphObject-ExtractImageToFile
	*/
	BOOL	ExtractImageToFile(LPCSTR lpcszPathName);
		
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphObject-GetNumOfNodes
	*/
	int		GetNumOfNodes();

#ifdef _POST_ORIGIN7_
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphObject-GetNode
	*/
	BOOL	GetNode(int nIndex, fpoint& ptNode);
#endif //_POST_ORIGIN7_

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphObject-GetObjectType
	*/
	string  GetObjectType(int * pnTypeID = NULL, BOOL bDetailedString = FALSE);
	
	// Comments last updated by Iris 07/22/2008, added #
	/**#
	*/
	int	GetRegionPoints(vectorbase& vValue);
	
	// Comments last updated by Iris 07/22/2008, added #
	/**#
	*/
	int	GetRegionPoints(vectorbase& vValue, vector<int>& vI, vector<int>& vJ);

	/// ML 11/18/2005 QA70-8332 SETTING_MF_TO_GRAPHOBJECT_OC
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphObject-SetMetafile
	*/
	BOOL	SetMetafile(LPCSTR lpcszPathName);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphObject-SetMetafile
	*/
	BOOL	SetMetafile(HMETAFILE hMF, int w = 0, int h = 0);
	/// end SETTING_MF_TO_GRAPHOBJECT_OC


	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphObject-GetLinkTable
	*/
	BOOL GetLinkTable(Worksheet& wks);

	///------ Folger 06/03/09 QA80-13713 GROBJ_NUMERIC_VARS_STORAGE_SUPPORT
	#ifdef		__GROBJ_NUMERIC_VARS_STORAGE__
	/**$
	*/
	int		GetStorageNumericVars(StringArray* psaNames, vector* parrValues);
	/**$
	*/
	int		SetStorageNumericVars(const StringArray* psaNames = NULL, const vector* parrValues = NULL, BOOL bUpdate = TRUE);
	#endif		/// __GROBJ_NUMERIC_VARS_STORAGE__
	///------ End GROBJ_NUMERIC_VARS_STORAGE_SUPPORT

	///Kyle 01/11/2010 QA80-14925 GRAPH_OBJECT_ALWAYS_REVERSE_VIDEO

	/**#
	*/
	BOOL IsReverseVideo();

	/**#
	*/
	BOOL SetReverseVideo(BOOL bSet = TRUE, BOOL bUndo = FALSE);
	///End GRAPH_OBJECT_ALWAYS_REVERSE_VIDEO

	///Kyle 06/11/2010 ORG-294 EXPOSE_MOVE_OBJECT_TO_OC
	/**#
		Remarks:
			bring object to the front or push it to the back etc.
		Example1:
			BOOL MoveObject_ex1()
			{
				GraphLayer gl = Project.ActiveLayer();
				if(gl)
				{
					GraphObject go;
					go = gl.GraphObjects("LINE");
					if(go)
						return go.MoveObject(MO_TOP);
				}
				return false;
			}
		Parameters:
			dwCntrl = [input] Combination of the following bits:
				MO_TOP, bring to the front
				MO_BOTTOM, push to the back
				MO_BEHIND_DATA, make it behind data
				MO_FRONT_DATA, bring to the front of data
				MO_TOGGLE_DATA, 
			bUndo = [input] whether the action should be undoable.
		Return:
			Return TRUE if success, or FALSE if failed.
	*/
	BOOL MoveObject(DWORD dwCntrl, BOOL bUndo = FALSE);
	///End EXPOSE_MOVE_OBJECT_TO_OC

	///Kyle 07/14/2010 ORG-571-S1 NO_SELECT_EFFECT_FOR_GRAPH_OBJECT
	/**#
	*/
	BOOL HasSelectEffect();

	/**#
	*/
	BOOL SetSelectEffect(BOOL bSet = TRUE, BOOL bUndo = FALSE);
	///End NO_SELECT_EFFECT_FOR_GRAPH_OBJECT

	///Kyle 07/16/2010 ORG-584-S2 PREVENT_DB_CLICK_ON_GRAPH_OBJECT
	/**#
	*/
	BOOL IsDBClickAllowed();

	/**#
	*/
	BOOL SetDBClick(BOOL bAllow = TRUE, BOOL bUndo = FALSE);
	///End PREVENT_DB_CLICK_ON_GRAPH_OBJECT
};

/**+
http://ocwiki.originlab.com/index.php?title=Category:StyleHolder_(class)
*/
class StyleHolder : public GraphObject
{
public:
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:StyleHolder-StyleHolder
	*/
	StyleHolder();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:StyleHolder-StyleHolder
	*/
	StyleHolder(StyleHolder &shOriginal);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:StyleHolder-GetDescription
	*/
	string			GetDescription();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:StyleHolder-GetPlotId
	*/
	int				GetPlotId(BOOL bBaseID = FALSE);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:StyleHolder-GetPlotDesignations
	*/
	string			GetPlotDesignations(DWORD *pdwFlags = NULL);
};

/// YuI 06/12/09 QA70-13595 SUPPORT_FOR_DATA_PLOT_ELEMENTS_ACCESS
#ifdef PLOT_ELEMENT_SUPPORT
class PlotElement	:	public OriginObject
{
protected:
	PlotElement();
	
public:
	~PlotElement();
	
public:
	#ifdef __EXTRACTING_CONTOUR_LINES__
	int             ExtractContourData(vector& vX, vector& vY, vector<int>& vCounts, vector& vLevels);
	/// Fisher 09/01/09	QA80-14237	FAIL_TO_EXTRACT_TERNARY_CONTOUR_DATA
	int				GetPlotType();
	/// End	FAIL_TO_EXTRACT_TERNARY_CONTOUR_DATA
	#endif	//__EXTRACTING_CONTOUR_LINES__
};

class	DataPoint : public PlotElement
{
public:
	DataPoint();
	DataPoint(const DataPoint& dp);
	DataPoint(DataPlot& dpOwner, int nIndex);
	~DataPoint();
	
public:
	BOOL	Attach(DataPlot& dp, int nIndex);
};
#endif //PLOT_ELEMENT_SUPPORT
/// end SUPPORT_FOR_DATA_PLOT_ELEMENTS_ACCESS
/**+
http://ocwiki.originlab.com/index.php?title=Category:DataObjectBase_(class)
*/
class DataObjectBase : public OriginObject
{
	
protected:
	/**
		Default constructor which constructs an uninitialized (unattached) DataObject.
		The object cannot be used until it is initialized.
	Parameters:

	Example:
		See examples for the methods of this class.
	*/
	DataObjectBase();

public:
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataObjectBase-SetRange
	*/
	BOOL	SetRange(int i1 = SETRANGE_FULL, int i2 = SETRANGE_FULL, BOOL bRepaint=TRUE);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataObjectBase-GetRange
	*/
	BOOL	GetRange(int &i1, int &i2);
	
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataObjectBase-i1
	*/
	int		i1;
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataObjectBase-i2
	*/
	int		i2;

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataObjectBase-GetDatasetName
	*/
	string	GetDatasetName();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataObjectBase-GetIndex
	*/
	int		GetIndex();
	
	//Comments updated by Joseph 07/30/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataObjectBase-GetCategoricalMap
	*/
	CategoricalMap	GetCategoricalMap();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataObjectBase-x0
	*/
	double x0;
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataObjectBase-xInc
	*/
	double xInc;
};

/**+
http://ocwiki.originlab.com/index.php?title=Category:DataObject_(class)
*/
class DataObject : public DataObjectBase
{
public:
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataObject-DataObject
	*/
	DataObject(); // Default constructor for DataObject class.

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataObject-GetInternalDataType
	*/
	UINT GetInternalDataType();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataObject-SetInternalDataType
	*/
	BOOL SetInternalDataType(UINT nType, DWORD dwFlags = 0);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataObject-GetInternalDataBuffer
	*/
	LPVOID GetInternalDataBuffer(int* pnElementSize = NULL, uint* pnNumElements = NULL);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataObject-ReleaseBuffer
	*/
	void ReleaseBuffer();
	
	// Last updated by Iris 02/19/2008
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataObject-SetMissingValue
	*/
	BOOL SetMissingValue(LPVOID pVal=NULL);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataObject-GetMissingValue
	*/
	BOOL GetMissingValue(LPVOID pVal);
// Last Updated 2005.03.29 GRD
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:DataObject-SetFormula
*/
	/// YuI 07/24/06 QA70-8847 COLUMN_FORMULA_FROM_ORIGIN_C_REVAMP
	//	BOOL	SetFormula(LPCSTR lpcszFormula); // Set the column formula
	BOOL	SetFormula(LPCSTR lpcszFormula, int nAutoUpdate = AU_NONE, int nBegin = -1, int nEnd = -1, BOOL bUndo = FALSE); // Set the column formula
	/// end COLUMN_FORMULA_FROM_ORIGIN_C_REVAMP


// Last Update : 2006.6.9 Cheney
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:DataObject-GetFormula
*/
	string	GetFormula(); // Get column formula from column

// Last Update : 2006.8.28 Joseph
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:DataObject-ExecuteFormula
*/
	BOOL	ExecuteFormula(int nBegin = -1, int nEnd = -1, BOOL bUndo = TRUE, int nC1 = -1, int nC2 = -1);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataObject-SetFormulaAutoUpdate
	*/
	BOOL	SetFormulaAutoUpdate(int nMode = AU_AUTO);


	/**#
	*/
	BOOL	SetFormulaAutoUpdate(int nBegin, int nEnd, int nMode = AU_AUTO);


	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataObject-IsFormulaAutoUpdate
	*/
	int		IsFormulaAutoUpdate(int* pBegin = NULL, int* pEnd = NULL);

	/**#
	*/
	BOOL	IsDataProtected(int nBegin = 0, int nEnd = -1);

	/// SY 2007-03-06 QA70-9440 v8.0577 OC_METHOD_REDUCE_SIZE
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataObject-ReduceSize
	*/
	int ReduceSize(int nSkip, DWORD dwCntrl, int nStart = 0, int nEnd = -1, int nBlockSize =1);
	/// end OC_METHOD_REDUCE_SIZE
};


/**+
http://ocwiki.originlab.com/index.php?title=Category:DataPlot_(class)
*/
class DataPlot : public DataObjectBase
{
public:
	//Comments last updated by Joseph 07/30/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataPlot-DataPlot
	*/
	DataPlot();
	
	//Comments last updated by Joseph 07/30/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataPlot-DataPlot
	*/
	DataPlot(DataPlot &dp);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataPlot-SetColor
	*/
	BOOL	SetColor(int nColor, BOOL bRepaint = FALSE, BOOL bUndo = false);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataPlot-SetColorRGB
	*/
	BOOL	SetColorRGB(BYTE byRed, BYTE byGreen, BYTE byBlue, BOOL bRepaint = FALSE);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataPlot-SetColormap
	*/
	BOOL	SetColormap(TreeNode& trColormap);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataPlot-SetColormap
	*/
	/// ML 12/19/2008 QA70-12802 SETTING_LEVELS_COLORS_TO_COLORMAP_OC_COM
	//BOOL	SetColormap(const vector<double>& vz, BOOL bLogScale=FALSE);
	BOOL	SetColormap(const vector<double>& vz, BOOL bLogScale=FALSE, const vector<uint> *vColors = NULL, const uint *pocolorBelow = NULL, const uint *pocolorAbove = NULL);
	/// end SETTING_LEVELS_COLORS_TO_COLORMAP_OC_COM
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataPlot-GetColormap
	*/
	BOOL	GetColormap(TreeNode& trColormap);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataPlot-GetColormap
	*/
	BOOL	GetColormap(vector<double>& vz, BOOL& bLogScale);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataPlot-SetActive
	*/
	int SetActive(int nMarkerLeft = -1, int nMarkerRight = -1);
	
#if	_OC_VER >=0x0800
	// CPY 7/27/2007 SKIP_ERR_BARS_WHEN_UPDATE_ADD_LEGEND, changed from GetType since base class also has GetType()
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataPlot-GetPlotType
	*/
	int	GetPlotType(DataPlotStrings* pDescStrs = NULL, BASIC_PLOT_SETTINGS* pstPlotSettings = NULL);
		
	// Comments last updated by Iris 07/22/2008, added #
	/**#
	*/
	BOOL	GetLinkedDatasetName(string& strName, int nType = LDT_MODIFIER);
	
	// Comments last updated by Iris 07/22/2008, added #
	/**#
	*/
	BOOL	SetLinkedDataset(LPCSTR lpcszDatasetName, int nType = LDT_MODIFIER);
	
	/**#
		Get data points that are inside the enclosed graphic object
	Parameters:
		obj = [input] a graphic object like a Rect or a polygone
		vx = [output] x coordinates of the found points
		vy = [output] y coordinates of the found points
		pIndeces = [output] indeces of the found points
		dwCtrl = [input] if set as GDPS_AFTER_MASK, can get masked points as missing values.
	Return:
		number of data points found or < 0 for error codes
	*/
	///Sophy 12/11/2009 QA80-14686 DATAPLOT_GET_DATAPOINTS_NEED_TO_SKIP_MASKED_DATA
	//int		GetDataPoints(OriginObject& obj, vector& vx, vector& vy, vector<int>* pIndeces = NULL);
	int		GetDataPoints(OriginObject& obj, vector& vx, vector& vy, vector<int>* pIndeces = NULL, DWORD dwCtrl = 0);
	///end DATAPLOT_GET_DATAPOINTS_NEED_TO_SKIP_MASKED_DATA

	///------ Folger 12/19/08 QA80-12815 v8.0988c SUPPORT_GET_DATA_POINTS_BY_RECT_MADE_OF_TWO_DOUBLE_POINTS
	/**#
		Get data points that are inside the enclosed rectangle
	Parameters:
		fptTopLeft = [input] top-left point of specific retangle
		fptBottomRight = [input]bottom-right point of specific retangle
		vx = [output] x coordinates of the found points
		vy = [output] y coordinates of the found points
		pvnIndices = [output] indices of the found points
	Return:
		number of data points found or < 0 for error codes
	*/
	int		GetRectPoints(fpoint& fptTopLeft, fpoint& fptBottomRight, vector& vX, vector& vY, vector<int>* pvnIndices = NULL);
	///------ End SUPPORT_GET_DATA_POINTS_BY_RECT_MADE_OF_TWO_DOUBLE_POINTS

	/// YuI 09/29/08 QA70-12265 CLEANUP_AND_ADDITIONAL_OC_INTERFACE_TO_GET_DATA_POINTS
	/**#
		Get data regions that are inside the enclosed graphic object
	Parameters:
		obj = [input] a graphic object like a Rect or a polygone
		vBegin = [output] indeces of regions first points 
		vEnd = [output] indeces of regions last points
		pIndeces = [output] indeces of the found points
	Return:
		number of regions found or < 0 for error codes
	*/
	int		GetDataRegions(OriginObject& obj, vector<int>& vBegin, vector<int>& vEnd, vector<int>* pIndeces = NULL);
	/// end CLEANUP_AND_ADDITIONAL_OC_INTERFACE_TO_GET_DATA_POINTS
	
	/// YuI 04/09/08 QA70-11394 GETN_CONTROL_FOR_SYMBOL_WELL
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataPlot-SetSymbol
	*/
	BOOL	SetSymbol(int nIndex, BOOL bUndo = FALSE);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataPlot-GetSymbol
	*/
	int		GetSymbol();
	/// end GETN_CONTROL_FOR_SYMBOL_WELL
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataPlot-XIndex
	*/
	int		XIndex(double dX, int& nIndex, DWORD dwCntrl = XIC_NEAREST_ANY);


	// Comments last updated by Iris 07/22/2008
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataPlot-GetDataRange
	*/
	BOOL	GetDataRange(DataRange& dr, int i1 = 0, int i2 = -1);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataPlot-GetDataPoint
	*/
	BOOL	GetDataPoint(int nIndex, double* pX, double* pY, double* pZ = NULL, double* pErr = NULL, DWORD dwCntrl = 0);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataPlot-GetDataPoints
	*/
	/// Hong 01/06/09 QA80-12852 v8.993e CURVE_TRANSLATE_NEED_TO_CREATE_SPEEDMODE_DATA_TO_SPEEDUP
	//int		GetDataPoints(int nrFrom, int nrTo, vector& vx, vector& vy, vector& vz = NULL, vector& vErr = NULL, DWORD dwCntrl = 0);
	int		GetDataPoints(int nrFrom, int nrTo, vector& vx, vector& vy, vector& vz = NULL, vector& vErr = NULL, DWORD dwCntrl = 0, int nPts = 800);
	/// end CURVE_TRANSLATE_NEED_TO_CREATE_SPEEDMODE_DATA_TO_SPEEDUP
	


	/**$
	*/
	BOOL	UpdateXYDataRangeTree(TreeNode &tr);

	/**$
	*/
	BOOL	UpdatePercentileDatasetEx();

	/// ML 12/4/2007 QA70-10624 OC_GETTING_INFO_ABOUT_SWAPPED_POLAR_FROM_DATAPLOT
	/**$
			Returns TRUE if the dataplot in polar layer has the configuration x=r,y=theta.
			Returns FALSE if the the dataplot is not in polar layer or in polar layer has the configuration x=theta,y=r
	*/
	BOOL	IsPolarSwapped();
	/// end OC_GETTING_INFO_ABOUT_SWAPPED_POLAR_FROM_DATAPLOT

	//----- CPY 8/21/08 QA70-12072 DATAPLOT_ALLOWS_X0_SHIFT_FOR_EVEN_SPACED_X_ADD_BITS_TO_REMEMBER
	/**$
	*/
	DWORD	GetSpecialFlags();
	//-----
	
	//------ CPY 9/7/08 QA70-12141 XY_SCATTER_USING_X_Y_VALUES_AS_SYMBO
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataPlot-LabTalk
	*/
	int		LabTalk(LPCSTR lpcszCmd, int* pnVal, BOOL bSet = true);
	//------ end

	/// YuI 12/12/07 EXPOSE_DATA_MARKERS_TO_OC
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataPlot-GetDataMarkers
	*/
	///Sophy 2/22/2010 QA80-14832 QUICKFIT_SWITCH_TO_NLFIT_SHOULD_USE_EXISTING_DATAMARKER_WHEN_SELECT_RANGE
	//int		GetDataMarkers(vector<int>& vBegin, vector<int>& vEnd);
	int		GetDataMarkers(vector<int>& vBegin, vector<int>& vEnd, vector<uint>& vIDs = NULL);
	///end QUICKFIT_SWITCH_TO_NLFIT_SHOULD_USE_EXISTING_DATAMARKER_WHEN_SELECT_RANGE
	/// end EXPOSE_DATA_MARKERS_TO_OC

	/// Kenny 09/25/2009 QA81-11561 WANT_LT_ACCESS_TO_DATA_INDEX_OF_DATA_MARKERS_IN_XF_MKS
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataPlot-SetDataMarkers
	*/
	int		SetDataMarkers(const vector<int>& vnBegin, const vector<int>& vnEnd, const vector<int>& vnIndices = NULL, BOOL bUndo = FALSE);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataPlot-AddDataMarkers
	*/
	int		AddDataMarkers(const vector<int>& vnBegin, const vector<int>& vnEnd, BOOL bInvalidate = TRUE, BOOL bUndo = FALSE);
	/// End QA81-11561 WANT_LT_ACCESS_TO_DATA_INDEX_OF_DATA_MARKERS_IN_XF_MKS
	
	/// YuI 12/04/08 QA70-12159 DATA_MARKERS_IN_WIZARD_PROBLEM
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataPlot-RemoveDataMarker
	*/
	int		RemoveDataMarker(int nBegin, int nEnd);
	/// end DATA_MARKERS_IN_WIZARD_PROBLEM

	/// YuI 03/30/07 QA70-9523 BOXCHART_UPDATE_AFTER_SOURCE_DATA_UPDATE
	/**$
	*/
	BOOL	GetStatsTreeStorageTag(string& strTag, BOOL& bOperation);
	/// end BOXCHART_UPDATE_AFTER_SOURCE_DATA_UPDATE

	/// YuI 12/21/07 QA7-10854 MOVE_HISTOGRAM_TO_VC
	/**$
	*/
	BOOL	GetStatsTree(TreeNode& trStats);

	/**$
	*/
	BOOL	UpdatePercentileDataset();
	/// end MOVE_HISTOGRAM_TO_VC

	//---- CPY 7/19/2007 QA70-10083 PLOT_LEGEND_CENTRALIZED_ACCESS
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataPlot-GetLegend
	*/
	BOOL GetLegend(string& str, LPCSTR lpcszCustomFormat = NULL, BOOL bClean = true);
	//----

	//----- CPY 11/09/2007 NLFIT_REPORT_NEED_BETTER_RESCALE_CONTROL
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataPlot-GetAxesScaleOverlap
	*/
	int GetAxesScaleOverlap(double* pfX, double* pfY, DWORD dwCntrl = 0);
	//----- end NLFIT_REPORT_NEED_BETTER_RESCALE_CONTROL

	/// RVD 3/13/09 QA70-13282 GET_GROUPPLOT_FROM_DATAPLOT
	/**#
		Get group plot from data plot
	Parameters:
		pnIndex = [output] optional pointer of index of dataplot in the group plot
	Return:
		Group plot object, NULL if dataplot is not groupped. This is a temporary object and should not be stored.
		Typical usage is on stack to get/set group plot theme. See example below.
	Example:
		void	get_active_plot_format()
		{
			GraphLayer gl = Project.ActiveLayer();
			if( gl )
			{
				DataPlot dp = gl.DataPlots();
				if( dp )
				{
					GroupPlot gp = dp.GetGroupPlot();
					Tree trFmt;
					if( gp )
						trFmt = gp.GetFormat(FPB_ALL, FOB_ALL, TRUE, TRUE);
					else
						trFmt = dp.GetFormat(FPB_ALL, FOB_ALL, TRUE, TRUE);
					out_tree(trFmt);
				}
			}
		}
	*/
	GroupPlot		GetGroupPlot(int* pnIndex = NULL);
	/// end GET_GROUPPLOT_FROM_DATAPLOT
	
	/// Fisher 6/9/2009 QA80-1863 EXTRACTING_CONTOUR_LINES
	#ifdef __EXTRACTING_CONTOUR_LINES__
	//	int             ExtractContourData(Column &colX, Column &colY, int nIndex = -1, BOOL bAllAtCurrentLevel = FALSE);
	int             ExtractContourData(vector& vX, vector& vY, vector<int>& vCounts, vector& vLevels);
	#endif	//__EXTRACTING_CONTOUR_LINES__
	/// End EXTRACTING_CONTOUR_LINES

	/// Fisher 7/16/2009 QA80-13897 NEW_METHOD_FOR_SET_COLORMAP_USING_OC
	#ifdef __COLORMAP_IMPROVEMENTS__
	BOOL	SetColorLevels(double dMin, double dMax, uint nMajorLevels, uint numMinorLevels = 0, int nScaleType = LINEAR_SPACE);
	#endif //__COLORMAP_IMPROVEMENTS__
	/// End NEW_METHOD_FOR_SET_COLORMAP_USING_OC

	/// Fisher 05/12/10 ORG-97 XYZ_CONTOUR_PROFILE
	TRIANGULATION*	GetTriangulationData();
	/// ----------------

	/// ML 11/26/2009 QA70-14743 SETTING_MODIFIERS_FROM_OC
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DataPlot-SetModifier
	*/
	int				SetModifier(int nDesig, Column &col);
	/// end SETTING_MODIFIERS_FROM_OC
	
	/// YuI 12/23/09 QA70-14885 PLOT_TO_DEPENDENT_SERIES_RELATION_BY_NAME
	/**$
	*/
	int 		SetRelatedDataset(LPCSTR lpcszName, const DatasetObject& dsObject);
	/**$
	*/
	BOOL 		GetRelatedDataset(LPCSTR lpcszName, DatasetObject& dsObject);
	/// end PLOT_TO_DEPENDENT_SERIES_RELATION_BY_NAME
	
	///------ Folger 12/25/09 QA81-14885 MORE_WORK_ON_SET_GET_RELATED_DATASET_FOR_OC
	/**$
	*/
	int			GetRelatedDatasetNames(vector<string>& arrNames);
	
	/**$
	Parameters:
		lpcszName=[input]name of related dataset to be removed, remove all datasets if lpcszName is NULL
	Returns:
		TRUE if successful, otherwise FALSE
	*/
	BOOL		RemoveRelatedDataset(LPCSTR lpcszName = NULL);
	///------ End MORE_WORK_ON_SET_GET_RELATED_DATASET_FOR_OC

	///------ Folger 01/18/10 QA81-14981 GET_PAGE_AVERAGE_COORDINATES_NEEDED_IN_OC
	/**$
	Parameters:
		pnY=[output]Page Y Coordinate
		pnX=[output]Page X Coordinate
	Returns:
		TRUE if successfully get the coordinates, otherwise FALSE
	*/
	BOOL		GetAveragePageCoordinates(LONG* pnY, LONG* pnX);
	///------ End GET_PAGE_AVERAGE_COORDINATES_NEEDED_IN_OC

	///------ Folger 08/04/10 ORG-705 COPY_COLORMAP_FORMAT_CONTEXT_MENU
	/**$
	*/
	BOOL		CopyColormapFormat(DWORD dwCntrl = 0);
	///------ End COPY_COLORMAP_FORMAT_CONTEXT_MENU

#endif //_OC_VER >=0x0800
};

#ifdef _POST_ORIGIN7_

/**+
http://ocwiki.originlab.com/index.php?title=Category:AxisObject_(class)
*/
class	AxisObject		:	public	OriginObject
{
public:
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:AxisObject-AxisObject
	*/
	AxisObject();
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:AxisObject-AxisObject
	*/
	AxisObject(const AxisObject& ao);

	///------ Folger 03/20/09 QA80-13326 SUPPORT_ACCESS_AXIS_POSITION_IN_OC
	/**+
	Parameters:
		pnType=[output]Position type
		prPos=[output]Position value
		pnPixel=[input]Logical Position
	Return:
		Absolute position value
	*/
	double		GetPosition(int* pnType = NULL, double* prPos = NULL, int* pnPixel = NULL);
	/**+
	Parameters:
		nType=[input]Position type
		rPos=[input]Position value
		bConvertOnly=[input]if TRUE then only convert (nType, rPos) into absolute postion value, otherwise AxisObject will be modified.
	Return:
		Absolute position value
	*/
	double		SetPosition(int nType, double rPos, BOOL bConvertOnly = FALSE);
	///------ End SUPPORT_ACCESS_AXIS_POSITION_IN_OC

	///------ Folger 04/10/09 QA80-13420 ACCESS_AXIS_LABEL_TYPE_AND_FORMAT_FROM_OC
	/**+
	Parameters:
		nType=[input]Axis label type, enum as OULABELTYPE
		lpcsz=[input]Text string for specific types :
			For OULABEL_TEXT, OULABEL_DATASET, OULABEL_CATEGORICAL, it means dataset name
			For OULABEL_STROBJ, it means tick-indexed string.
			For other types, it should be NULL.
		nFormat=[input]Display format for OULABEL_NUMERIC, OULABEL_TIME, OULABEL_DATE, OULABEL_MONTH, OULABEL_DAYOFWEEK, OULABEL_COLUMN
	Return:
		Return 0 if no error, otherwise error code enumeration as AXISLABELACCESSERROR
	*/
	int			SetTypeFormatEtc(int nType, LPCSTR lpcsz, int nFormat = -1);
	/**+
	Parameters:
		nType=[output]Axis label type, enum as OULABELTYPE
		pstr=[output]Text string for specific types :
			For OULABEL_TEXT, OULABEL_DATASET, OULABEL_CATEGORICAL, it means dataset name
			For OULABEL_STROBJ, it means tick-indexed string.
			For other types, it should be NULL.
		pnFormat=[output]Display format for OULABEL_NUMERIC, OULABEL_TIME, OULABEL_DATE, OULABEL_MONTH, OULABEL_DAYOFWEEK, OULABEL_COLUMN
	Return:
		Return 0 if no error, otherwise error code enumeration as AXISLABELACCESSERROR
	*/
	int			GetTypeFormatEtc(int &nType, string* pstr = NULL, int* pnFormat = NULL);
	///------ End ACCESS_AXIS_LABEL_TYPE_AND_FORMAT_FROM_OC

	/// Kenny 07/27/2009 QA80-14019 SUPPORT_ACCESS_AXIS_TITLE_OBJECT_IN_OC
	/**+
	Parameters:
		lpcszDefaultText=[input] The default text, used only when the title object does NOT exist.
	Return:
		Return the title text object, if the title object does not exist and the input text was invalid/empty, the returned object is invalid.
	*/
	GraphObject	GetTitleObject(LPCSTR lpcszDefaultText = NULL);
	/// End QA80-14019 SUPPORT_ACCESS_AXIS_TITLE_OBJECT_IN_OC
};

/**+
http://ocwiki.originlab.com/index.php?title=Category:Axis_(class)
*/
class	Axis		:	public OriginObject
{
public:
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Axis-Axis
	*/
	Axis();
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Axis-Axis
	*/
	Axis(const Axis& axis);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Axis-AxisObjects
	*/
	AxisObject		AxisObjects(int nIndex);
};

/**+
http://ocwiki.originlab.com/index.php?title=Category:GroupPlot_(class)
*/
class	GroupPlot	:	public	OriginObject
{
public:
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GroupPlot-GroupPlot
	*/
	GroupPlot();
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GroupPlot-GroupPlot
	*/
	GroupPlot(const GroupPlot& gp);

public:
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GroupPlot-GetCount
	*/
	int			GetCount();
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GroupPlot-GetDataPlot
	*/
	DataPlot	GetDataPlot(int nIndex);
};

/**+
http://ocwiki.originlab.com/index.php?title=Category:point_(class)
*/
class point
{
public:

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:point-point
	*/
	point(int x = 0, int y = 0);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:point-point
	*/
	point(point pp);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:point-x
	*/
	int 	x;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:point-y
	*/
	int 	y;
};

/**+
http://ocwiki.originlab.com/index.php?title=Category:fpoint_(class)
*/
class fpoint
{
public:

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:fpoint-fpoint
	*/
	fpoint(double x = 0, double y = 0);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:fpoint-fpoint
	*/
	fpoint(fpoint pp);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:fpoint-x
	*/
	double 	x;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:fpoint-y
	*/
	double 	y;
};

/**+
http://ocwiki.originlab.com/index.php?title=Category:fpoint3d_(class)
*/
class fpoint3d
{
public:

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:fpoint3d-fpoint3d
	*/
	fpoint3d(double x = 0, double y = 0, double z = 0);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:fpoint3d-fpoint3d
	*/
	fpoint3d(fpoint3d pp);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:fpoint3d-x
	*/
	double 	x;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:fpoint3d-y
	*/
	double 	y;

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:fpoint3d-z
	*/
	double 	z;
};

#endif // _POST_ORIGIN7_
		

/**+
http://ocwiki.originlab.com/index.php?title=Category:ROIObject_(class)
*/
class ROIObject : public GraphObject
{
public:

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ROIObject-ROIObject
	*/
	ROIObject();
};

#if  _OC_VER >= 0x0800

/// Comments last updated by Cloud 03/15/2007
/**# >
*/
class	PolylineGraphObject	:	public GraphObject
{
public:
	/**#
	*/
	//----------- CPY FISHER 3/10/2008 QA70-11233 TRI_CONTOUR_LINES_ACCESS_FROM_OC, change to use double for world coordinate points
	//int		SetPoints(vector<float>& vX, vector<float>& vY);
	int		SetPoints(vector& vX, vector& vY);
	//-----------
	// vectors must be prepared first and be of correct size
	// to get size call with NULL's - will return number of points
	/**#
	*/
	//int		GetPoints(vector<float>& vX = NULL, vector<float>& vY = NULL);
	int		GetPoints(vector& vX = NULL, vector& vY = NULL);
};

#ifdef	__MARKER_GRAPHIC_OBJECT__
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MarkerGraphObject_(class)
*/
class	MarkerGraphObject	:	public	PolylineGraphObject
{
};
#endif //	__MARKER_GRAPHIC_OBJECT__
/**# >
*/
class	PolyPolylineGraphObject	:	public	GraphObject
{
public:
	/**#
	*/
	int		GetInternalSelection(vector<int>& vSelection);
	
	/**
		Get points along a drawn shape
	Parameters:
		vX = [output] X coordinates in world units (axis units)
		vy = [output] Y coordinates
		nIndex = [input] for poly polygon, index of the polygon
	Return:
		Number of points or -1 for error
	Example:
		void GetTraceData()
		{
			PolylineGraphObject gr;
			
			// first step - get selected object
			gr = Selection.Objects();
			if( gr )
			{
				vector vx;
				vector vy;
					
				// get trace points in axis coordinates
				if( gr.GetPoints(vx, vy) > 0 )
				{
					// create new worksheet
					Worksheet wks;
					wks.Create();
					// make sure we have at least two columns in the worksheet
					wks.SetSize(-1,2);
					// finally put data in
					Dataset dsX(wks, 0);
					Dataset dsY(wks, 1);
					dsX = vx;
					dsY = vy;
				}
			}
		}
	*/
	int		GetPoints(vector& vX = NULL, vector& vY = NULL, int nIndex = 0);
	
	/**#
	*/
	int		SetPoints(vector& vX, vector& vY, int nIndex);
	
	/**#
	*/	
	int		GetPolylineCount();
	
	/// Fisher 03/04/10 Qa80-15166-S1 MORE_ON_POLYPOLYGON_GR_OBJECT
	/**#
	*/	
	int		AddPolyline(vector& vX, vector& vY);
	
	/**#
	*/	
	int		RemovePolyline(int nIndex);	
	
	/**#
	*/	
	int		ConstructFromImage(vector<int> &vImage, int nRows, int nCols, int nRegions);
	/// End MORE_ON_POLYPOLYGON_GR_OBJECT
	
	///-----Kit 10/21/2010 RSRCH-29	REMOVE_TEXT_AT_BOTTOM_OF_IMAGE
#ifdef	__ADD_CTRL_BIT_FOR_POLYPOLYLINE_DRAWING__
	/**#
	*/
	BOOL	SetDrawOption( DWORD dwDrawOpt );
	
	/**#
	*/
	DWORD	GetDrawOption();
	///-----End REMOVE_TEXT_AT_BOTTOM_OF_IMAGE
#endif  //__ADD_CTRL_BIT_FOR_POLYPOLYLINE_DRAWING__
};

///Comments last updated by Cloud on 03/15/2007
/**# >
*/
class	DataSelector	:	public	PolyPolylineGraphObject
{
	/**#
	*/
	void	Destroy(BOOL bSelectionOk);
	
	/**#
	*/
	BOOL	SetTree(const TreeNode& tr);
	
	/**#
	*/
	BOOL	GetTree(TreeNode& tr);
	
	/**#
	*/
	int		SetI1(int i1, BOOL bRedraw = TRUE);
	
	/**#
	*/
	int		SetI2(int i2, BOOL bRedraw = TRUE);
	
	/**#
	*/
	int		GetI1();
	
	/**#
	*/
	int		GetI2();
	
	/**#
	*/
	int		GetI1Temp();
	
	/**#
	*/
	int		GetI2Temp();
	
	/**#
	*/
	int		GetIMin();
	
	/**#
	*/
	int		GetIMax();
	
	/**#
	*/
	double			GetX1();
	/**#
	*/
	double			GetX2();
	/**#
	*/
	double			GetY1();
	/**#
	*/
	double			GetY2();
	/**#
	*/
	double			GetX1Temp();
	/**#
	*/
	double			GetX2Temp();
	/**#
	*/
	double			GetY1Temp();
	/**#
	*/
	double			GetY2Temp();
};
#endif //  _OC_VER >= 0x0800
#pragma	dll(@OK)
/**$ >Internal Origin Objects
*/
ROIObject		GetROI();

#endif //_GRAPH_H
